// mame_ui.c : Defines the entry point for the application.
// SEP00: Gandalf

#include "stdafx.h"
#include "resource.h"
#include "game_info.h"
#include "driver.h"
#include "basename.h"
#include "file.h" // GN: FTEST


// I don't like this here
#ifdef GAMEX
#include "cgamex.h"
#endif


#define MAX_LOADSTRING 100
//Menu Bar Height
#define MENU_HEIGHT 26


extern int g_Samplerate;
extern BOOL g_ShowFPS;
extern int play_sound;

int run_game(int argc,char **argv);


// Global Variables:
HINSTANCE g_hInst;				           // current instance
TCHAR     g_szTitle[MAX_LOADSTRING];       // The title bar text
TCHAR     g_szWindowClass[MAX_LOADSTRING]; // The title bar text
HWND      g_hUIwnd;

HWND      g_hMainWind;



// local variables
static int m_playgame = -1;

static HWND m_hwndList;
static HWND m_hwndFskip;
static HWND m_hwndSndck;
static HWND m_hwndSamplerate;
static HWND m_hwndShowFPS;

HWND   hwndCB;			// The command bar handle



// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE);
HWND /* BOOL */		InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	MainDlgProc (HWND, UINT, WPARAM, LPARAM);

static BOOL Win32UI_init(HWND, HINSTANCE);
static void SetupUI(HWND);
static BOOL PlayGame(int game, HWND hwndFskip, HWND hwndSamplerate, HWND hwndSndck, HWND hwndShowFPS);



// Application entry point //////////////////////////////////////////

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine, // LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	int res = TRUE;
	BOOL firsttime = TRUE;

	MSG msg;
	HACCEL hAccelTable;
	HWND hMainwnd;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, g_szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_IMAME, g_szWindowClass, MAX_LOADSTRING);
	
	// Look for running instance of application
	if (FindWindow(g_szWindowClass, g_szTitle))
	{
		SetForegroundWindow(FindWindow(g_szWindowClass, g_szTitle));
		return FALSE;
	}
	
	// Perform application initialization:
	if ( 0 == (hMainwnd = InitInstance (hInstance, nCmdShow) ) )
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_IMAME);


	// Retrieve path, from the registry.
    // default should be returned if one is not available 
	GetSampleDirs(); // GN: FTEST-actually would be done from File.init
	GetRomDirs(); // GN: FTEST-actually would be done from File.init



	g_hMainWind = hMainwnd;

    // init files after OptionsInit to init paths (GN: from Win32UI_Init)
    File.init(); // GN: FTEST
    InitZip(hMainwnd); // GN: FTEST


    if ( !Win32UI_init(g_hUIwnd, hInstance) )
        return 1;


	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);

			if (m_playgame >= 0)
			{
//			    ShowWindow(hMainwnd, SW_HIDE);

				res = PlayGame(m_playgame, m_hwndFskip, m_hwndSamplerate, m_hwndSndck, m_hwndShowFPS);

//				ShowWindow(g_hUIwnd, SW_SHOW);

				if ( FALSE == res )
				{
					MessageBox(NULL, 
						TEXT("Problem initializing Mame core...hardware incompatibility or perhaps a missing ROM file"),
						TEXT("Mame core error"), MB_OK);
				}

				m_playgame = -1;
			}
		}
	}

#ifdef GAMEX
	// I don't like this here!
	GAMEX_Close();
#endif


	// GN: from Win32UI_Exit
    ExitZip(); // GN: FTEST
    File.exit(); // GN: FTEST


	return msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInst )
{
	WNDCLASS wcex; // WNDCLASSEX wcex;
	
//	wcex.cbSize         = sizeof(WNDCLASS); // sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInst;
	wcex.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_IMAME);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= 0; // (LPCTSTR)IDC_IMAME;
	wcex.lpszClassName	= g_szWindowClass;
//	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);
	return RegisterClass(&wcex); // return RegisterClassEx(&wcex);
}



//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
HWND InitInstance(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;

	g_hInst = hInst; // Store instance handle in our global variable

	MyRegisterClass(hInst /* hInstance */);

#ifdef _WIN32_WCE	
	hWnd = CreateWindow(g_szWindowClass, g_szTitle, WS_VISIBLE, // WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, GetSystemMetrics(SM_CXSCREEN), 
		GetSystemMetrics(SM_CYSCREEN), NULL, NULL, hInst, NULL);
#else	
	hWnd = CreateWindow(g_szWindowClass, g_szTitle, WS_VISIBLE, // WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, 240 /* CW_USEDEFAULT */, 320 /* 0 */, NULL, NULL, hInst, NULL);
#endif

	if (!hWnd)
	{
		return FALSE;
	}
	

  //When the main window is created using CW_USEDEFAULT the height of the menubar (if one
  // is created is not taken into account). So we resize the window after creating it
  // if a menubar is present
#if _WIN32_WCE > 211 //Rapier devices
  {
    RECT rc;
    GetWindowRect(hWnd, &rc);
    rc.bottom -= MENU_HEIGHT;
    if (hwndCB)
      MoveWindow(hWnd, rc.left, rc.top, rc.right, rc.bottom, FALSE);
  }
#endif


	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	
	return hWnd; // return TRUE;
}



//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#if _WIN32_WCE > 211 //Rapier devices
    SHMENUBARINFO mbi;
#endif


	int wmId, wmEvent;
	RECT rect;

	BOOL res = 0;

	switch (message) 
	{
		case WM_HELP:
#ifdef _WIN32_WCE
			res = CreateProcess( TEXT("peghelp.exe"),
				TEXT("file:imamehlp.htm#play"), NULL, NULL, FALSE, 0, NULL,
				NULL, NULL, NULL);
#endif
			break;

		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 

			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_MAIN_ABOUT:
					DialogBox(g_hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
					break;
				case IDM_MAIN_EXIT:
					DestroyWindow(hWnd);
					break;
				case IDM_DIR_ROM:
					// Browse for a new mamebin path
					MameDir_Set(TEXT("Roms"));
					// Force file directories to refresh
					File.exit();
					File.init();
					break;
				case IDM_DIR_SAMPLE:
					// Browse for a new mamebin path
					MameDir_Set(TEXT("Samples"));
					// Force file directories to refresh
					File.exit();
					File.init();
					break;
				default:
					return DefWindowProc(hWnd, message, wParam, lParam);
			}
		break;
		
		case WM_CREATE:

#if _WIN32_WCE > 211 //Rapier devices
        //Create 'Rapier' type MenuBa
	        memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize     = sizeof(SHMENUBARINFO);
			mbi.hwndParent = hWnd;
			mbi.nToolBarId = IDM_MAIN_MENU;
			mbi.hInstRes   = g_hInst;
			mbi.nBmpId     = 0;
			mbi.cBmpImages = 0;	
        
	        if (!SHCreateMenuBar(&mbi))
		      MessageBox(hWnd, L"SHCreateMenuBar Failed", L"Error", MB_OK);
	        hwndCB = mbi.hwndMB;
#endif

			// Create the DialogWindow and center it under the commandbar
			GetClientRect(hWnd, &rect);

			if ( g_hUIwnd = CreateDialog(g_hInst, MAKEINTRESOURCE(IDD_MAME), hWnd, (DLGPROC)MainDlgProc) )
			{
				MoveWindow( g_hUIwnd, rect.left, rect.top, 
					rect.right-rect.left,rect.bottom - rect.top, TRUE);

				ShowWindow( g_hUIwnd, SW_SHOW);
				UpdateWindow( g_hUIwnd );
			}
			//
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}


// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
#if _WIN32_WCE > 211 //Rapier devices
      SHINITDLGINFO shidi;
#endif

	switch (message)
	{
	case WM_INITDIALOG:
#if _WIN32_WCE > 211 //Rapier devices
      //On Rapier devices you normally create all Dialog's as fullscreen dialog's
      // with an OK button in the upper corner. You should get/set any program settings
      // during each modal dialog creation and destruction

      // Create a Done button and size it.
      shidi.dwMask = SHIDIM_FLAGS;
      shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
      shidi.hDlg = hDlg;
      //initialzes the dialog based on the dwFlags parameter
      SHInitDialog(&shidi);
      
#endif // _WIN32_WCE < 212//non-Rapier devices

		return TRUE;
		
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
    return FALSE;
}


//------------------------------------------------------
// MainDlgProc
//------------------------------------------------------
LRESULT CALLBACK MainDlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{  
	LRESULT	lResult = TRUE;
	int wmEvent = HIWORD(wParam); 
	int vkey = LOWORD(wParam);

	switch(msg)
	{

/* GN: V7, do we need this?
	case WM_DESTROY:
		PostQuitMessage(0);
		break;	// end case WM_DESTROY
*/

	case WM_VKEYTOITEM:
		switch( vkey )
		{
			case VK_F23:
				m_playgame = SendMessage(m_hwndList, LB_GETCURSEL, 0, 0);
				break;
		}
		break;


	// WM_KEYDOWN is not getting sent to this Window....what's up w/ that?
	case WM_KEYDOWN:
		switch( wParam )
		{
			case VK_F23:
				m_playgame = SendMessage(m_hwndList, LB_GETCURSEL, 0, 0);
				break;
		}
		break;


/* GN: V7, do we need this?
	case WM_CLOSE:
		DestroyWindow(hWnd);
		return TRUE;
		break;
*/

	case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
			case IDC_LIST:
				if (wmEvent == LBN_DBLCLK)
					m_playgame = SendMessage(m_hwndList, LB_GETCURSEL, 0, 0);
				break;
			case IDC_ACTION:
				m_playgame = SendMessage(m_hwndList, LB_GETCURSEL, 0, 0);
				break;
			case IDC_GAMEINFO:
				ShowGameInfo( SendMessage(m_hwndList, LB_GETCURSEL, 0, 0) );
				break;
			case IDC_BTNROMDIR:
				// Browse for a new mamebin path
				MameDir_Set(TEXT("Roms"));
				// Force file directories to refresh
				File.exit();
				File.init();
				break;
			case IDC_BTNSAMDIR:
				// Browse for a new mamebin path
				MameDir_Set(TEXT("Samples"));
				// Force file directories to refresh
				File.exit();
				File.init();
				break;
			default:
				break;
			}	// end switch(LOWORD(wParam))
			
			break; // end case WM_COMMAND
		}

		
    case WM_INITDIALOG:
		{
			;//Something
		}
		break;
		
    default:
		//return DefWindowProc(hwnd, msg, wp, lp);
		return(FALSE);
		break;
	}
	
	UNREFERENCED_PARAMETER(wParam);
	UNREFERENCED_PARAMETER(lParam);
	return (lResult);
}



////////////////////////////////////////////////////////////////
static BOOL Win32UI_init(HWND hUIwnd, HINSTANCE hInstance)
{
	// Create the main dlg
	SetupUI(hUIwnd);
	MakeGameList(m_hwndList);

	return TRUE;
}



/////////////////////////////////////////////////////////////
static void SetupUI(HWND hUIwnd)
{
	// Get handles to UI elements
    m_hwndList       = GetDlgItem(hUIwnd, IDC_LIST);

	m_hwndSndck      = GetDlgItem(hUIwnd, IDC_SOUNDEN);
	m_hwndSamplerate = GetDlgItem(hUIwnd, IDC_SAMPLERATE);
	m_hwndShowFPS    = GetDlgItem(hUIwnd, IDC_SHOWFPS);
	m_hwndFskip	     = GetDlgItem(hUIwnd, IDC_FSKIP);

	// Initialize state of UI elements
    SendMessage(m_hwndFskip, CB_RESETCONTENT, 0, 0); 
    SendMessage(m_hwndFskip, CB_ADDSTRING, 0, (LPARAM)TEXT("0") ); 
    SendMessage(m_hwndFskip, CB_ADDSTRING, 0, (LPARAM)TEXT("1") ); 
    SendMessage(m_hwndFskip, CB_ADDSTRING, 0, (LPARAM)TEXT("2") ); 
    SendMessage(m_hwndFskip, CB_ADDSTRING, 0, (LPARAM)TEXT("3") ); 
	SendMessage(m_hwndFskip, CB_SETCURSEL, 0, 0);

	SendMessage(m_hwndSndck, BM_SETCHECK, BST_CHECKED, 0);

	SendMessage(m_hwndShowFPS, BM_SETCHECK, BST_UNCHECKED, 0);

    SendMessage(m_hwndSamplerate, CB_ADDSTRING, 0, (LPARAM)TEXT("11025") ); 
    SendMessage(m_hwndSamplerate, CB_ADDSTRING, 1, (LPARAM)TEXT("22050") ); 
    SendMessage(m_hwndSamplerate, CB_ADDSTRING, 2, (LPARAM)TEXT("44100") ); 
	SendMessage(m_hwndSamplerate, CB_SETCURSEL, 0, 0);
}



/////////////////////////////////////////////////////////////
static BOOL PlayGame(int game, HWND hwndFskip, HWND hwndSamplerate, HWND hwndSndck, HWND hwndShowFPS)
{
	int res = TRUE;

	TCHAR strSamplerate[16];
	HWND hPrevWnd = NULL;	// Find the UI window after playing

	char strFskip[] = "0";

	char *argv[] = {
		"junk", drivers[game]->name, "-frameskip", strFskip
	};

	int fskip = SendMessage(hwndFskip, CB_GETCURSEL, 0, 0);
	int samprate = SendMessage(hwndSamplerate, CB_GETCURSEL, 0, 0);


	SendMessage( hwndSamplerate, CB_GETLBTEXT, samprate, strSamplerate);
#ifdef _WIN32_WCE
	swscanf(strSamplerate, TEXT("%d"), &g_Samplerate);
#else
	sscanf(strSamplerate, "%d", &g_Samplerate);
#endif


	play_sound = 0;
	if (SendMessage(hwndSndck, BM_GETCHECK, 0, 0) == BST_CHECKED)
	{
		play_sound = 1;
	}
	if (play_sound == 0)
	{
		g_Samplerate = 0;
	}

	if (SendMessage(hwndShowFPS, BM_GETCHECK, 0, 0) == BST_CHECKED)
	{
		g_ShowFPS = 1;
	}


//	sprintf(strFskip, "%d", fskip);
#ifdef _WIN32_WCE
	_itoa(fskip, strFskip, 10);
#else
	itoa(fskip, strFskip, 10);
#endif

	if ( 1 == run_game(4, argv) )
	{
		res = FALSE;
		/*
		MessageBox(NULL, 
			TEXT("Problem initializing Mame core...hardware incompatibility or perhaps a missing ROM file"),
			TEXT("Mame core error"), MB_OK);
		*/
	}

	// Here is the basic message loop.
	// The "while" loop is essentially the Mame run_machine procedure.
	// ProcessMessages is called by "osd_update_display"
/*
	while (running_game)
	{
		if (Key == 1) 
		{
			TextOut(hAppDC, 10, 10, "Hello", strlen("Hello") );
			Key = 0;
		}
		MAME32_ProcessMessages();
	}
*/


#if USED
	// Find UI window after playing
	hPrevWnd = FindWindow(NULL, TEXT("iMAME"));
	if (hPrevWnd) 
	{
		SetForegroundWindow(hPrevWnd);
	}
#endif

	return res;
}
